
JVRE={MajorVer:0,MinorVer:0,Build:0,Fix:0,Debug:true,Global:(function(){return this;}()),Error:{E_FAIL:0x80004005,E_INVALIDARG:0x80070057,E_NOTIMPL:0x80004001},log:false,Browser:Browser||{}};JVRE.Exception=new Class({initialize:function(message,errorCode){this._message=message||"E_FAIL exception";this._errorCode=errorCode||JVRE.Error.E_FAIL;if(JVRE.log)
debug.error("[JVRE.Exception] "+message);}})
JVRE.DependencyProperty=new Class(function(){return{initialize:function(name,type,owner,persistent,validate){this._name=name;this._type=type;this._owner=owner;this._persistent=persistent;this._validate=validate;},validate:function(value){if(!instanceOf(value,this._type))
throw new JVRE.Exception("type of value is not correct",JVRE.Error.E_FAIL);if(this._validate&&!this._validate(value,this.type))
throw new JVRE.Exception("value is not valid",JVRE.Error.E_FAIL);}};}());JVRE.DependencyObject=new Class(function(){return{Implements:Events,initialize:function(){this._$props={_$:{}};},property:function(dp,value){if(!instanceOf(dp,JVRE.DependencyProperty))throw new JVRE.Exception("key invalid argument",JVRE.Error.E_INVALIDARG);var properties=dp._persistent?this._$props:this._$props._$;if(value===undefined&&dp._name in properties)
return properties[dp._name];else if(value!==undefined){dp.validate(value);var oldValue=properties[dp._name];properties[dp._name]=value;if(!oldValue)
this.fireEvent(dp._name+"_add",dp,oldValue);else
this.fireEvent(dp._name+"_change",dp,oldValue,value);}
return undefined;},clearValue:function(dp){if(!instanceOf(dp,JVRE.DependencyProperty))throw new JVRE.Exception("key invalid argument",JVRE.Error.E_INVALIDARG);var properties=dp._persistent?this._$props:this._$props._$;if(properties.hasOwnProperty(dp._name)){var oldValue=properties[dp._name];delete properties[dp._name];this.fireEvent(dp._name+"_delete",dp,oldValue);}}};}());JVRE.Base=new Class(function(){return{_$pt:"JVRE.Base",initialize:function(){}};}());JVRE.Base.getRefNode=function(ref_path){if(!ref_path)
throw new JVRE.Exception("ref_path invalid argument",JVRE.Error.E_INVALIDARG);var ref_nodes=ref_path.split('.');var length=ref_nodes.length;var ref_node=JVRE.Global[ref_nodes[0]];for(var i=1;i<ref_nodes.length;++i){if(!ref_node.hasOwnProperty(ref_nodes[i]))
throw new JVRE.Exception("ref_path not found");ref_node=ref_node[ref_nodes[i]];}
return ref_node;};JVRE.Persistent=new Class(function(){return{Extends:JVRE.Base,_$pt:"JVRE.Persistent",initialize:function(){this.parent();},needSerialize:function(){return true;},_unserialize:function(data){if(!data._$pt&&data._$pt!=this._$pt)
throw new JVRE.Exception("_$pt not match");for(var property in data){if(!data.hasOwnProperty(property))
continue;if(property=="_$pt")
continue;if(instanceOf(this[property],Function))
throw new JVRE.Exception();if(property=="_$props"){for(name in data._$props){if(!data._$props.hasOwnProperty(name))
continue;if(instanceOf(data._$props[name],Function))
throw new JVRE.Exception();this._$props[name]=JVRE.Persistent.unserialize(data._$props[name]);}
continue;}
if(instanceOf(this[property],Array)){this[property]=[];var that=this;Array.each(data[property],function(value,index){that[property][index]=JVRE.Persistent.unserialize(value);});continue;}
this[property]=JVRE.Persistent.unserialize(data[property]);}},serialize:function(){var data={};data._$pt=this._$pt;if(this.needSerialize()==false)
return undefined;for(var property in this){if(!this.hasOwnProperty(property))
continue;if(property=="caller"||property=="$caller"||property=="$events"||property=="_$")
continue;if(instanceOf(this[property],Function))
continue;if(property=="_$props"){var props={};var count=0;for(name in this._$props){if(!this._$props.hasOwnProperty(name))
continue;if(name=="_$")
continue;if(instanceOf(this._$props[name],Function))
continue;var tmp=JVRE.Persistent.serialize(this._$props[name]);if(tmp!==undefined)
props[name]=tmp;++count;}
if(count!=0)
data._$props=props;continue;}
if(instanceOf(this[property],Array)){if(this[property].length==0)
continue;data[property]=[];Array.each(this[property],function(value,index){var tmp=JVRE.Persistent.serialize(value);if(tmp!==undefined)
data[property][index]=tmp;});continue;}
var tmp=JVRE.Persistent.serialize(this[property]);;if(tmp!==undefined)
data[property]=tmp;}
return data;}};}());JVRE.Persistent.serialize=function(obj){if(instanceOf(obj,Function))
throw new JVRE.Exception("obj invalid argument",JVRE.Error.E_INVALIDARG);if(instanceOf(obj,JVRE.Persistent)){if(obj.needSerialize()==false)
return undefined;return obj.serialize();}
else
return obj;};JVRE.Persistent.unserialize=function(data){if(instanceOf(data,Function))
throw new JVRE.Exception("obj invalid argument",JVRE.Error.E_INVALIDARG);if(!data||!data._$pt)
return data;var constructor=JVRE.Base.getRefNode("JVRE."+data._$pt);if(!constructor)throw new JVRE.Exception("constructor not found");var object=new constructor();object._unserialize(data);return object;};JVRE.Media=new Class(function(){var _mediaCount=0;return{Extends:JVRE.Persistent,Implements:JVRE.DependencyObject,initialize:function(){this.parent();this._$=this._$||{};this._$._context=null;this._$._loadStare=JVRE.Media.LoadState.None;this._$._ready=false;this._$._mediaID=function(){return++_mediaCount;}();this._$._currentTime=0;},mediaID:function(){return this._$._mediaID;},loadStare:function(){return this._$._loadStare;},context:function(){return this._$._context;},isPresent:function(){return true;},isReady:function(){return this._$._ready;},reset:function(){this._$._context=null;this._$._loadStare=JVRE.Media.LoadState.None;this._$._ready=false;this._$._currentTime=0;},load:function(context){if(this._$._context!==null)
throw new JVRE.Exception("unexpected behavior",JVRE.Error.E_FAIL);this._$._context=context;this._$._loadStare=JVRE.Media.LoadState.Loading;this._$._ready=false;},networkIdle:function(){return true;},duration:function(){throw new JVRE.Exception("pure virtual fucntion",JVRE.Error.E_NOTIMPL);},run:function(currentTime){this._$._currentTime=currentTime;return 0;},play:function(){},pause:function(){},currentTime:function(time){if(time===undefined)
return this._$._currentTime;else throw new JVRE.Exception("pure virtual fucntion",JVRE.Error.E_NOTIMPL);},buffered:function(time){return true;},render:function(context){}};}());JVRE.Media.LoadState={None:0,Loading:1,Loaded:2};JVRE.Range=new Class(function(){return{Extends:JVRE.Persistent,_$pt:"Range",initialize:function(begin,end){this.parent();this._begin=begin||0;this._end=end||0;},range:function(begin,end){if(begin<0||end<0||end<=begin)
throw new JVRE.Exception("begin, end invalid argument",JVRE.Error.E_INVALIDARG);this._begin=begin;this._end=end;},begin:function(begin){if(begin===undefined)
return this._begin;else if(begin<this._end)
this._begin=begin;else
throw new JVRE.Exception("begin invalid argument",JVRE.Error.E_INVALIDARG);},end:function(end){if(end===undefined)
return this._end;else if(end>this._begin)
this._end=end;else
throw new JVRE.Exception("end invalid argument",JVRE.Error.E_INVALIDARG);},duration:function(){return this._end-this._begin;}};}());JVRE.BeginTime=new JVRE.DependencyProperty("BeginTime",Number,JVRE,true,function(value){return value>=0;});JVRE.BindURL=new JVRE.DependencyProperty("BindURL",String,JVRE,true,null);JVRE.Key=new Class(function(){return{Extends:JVRE.Persistent,Implements:JVRE.DependencyObject,_$pt:"Key",initialize:function(duration,value,algorithm){this.parent();this.d=duration;this.v=value;if(algorithm===undefined)
this.a=new JVRE.IP.Discrete();else
this.a=algorithm;},interpolation:function(baseValue,progress){return this.a.interpolation(baseValue,progress,this);}};}());JVRE.IP=new Class(function(){return{Extends:JVRE.Persistent,_$pt:"IP",initialize:function(value){this.parent();this._$=this._$||{};this._$.defV=value;this.v=undefined;this.k=[];},needSerialize:function(){return this.v!==undefined||this.k.length!=0;},serialize:function(){this.v=(this.v===undefined?this._$.defV:this.v);return this.parent();},value:function(currentTime){if(this.k.length===0||currentTime===undefined)
return(this.v===undefined?this._$.defV:this.v);var index=0;var time=0;for(;index<this.k.length;++index){var pair=this.k[index];if(time<=currentTime&&currentTime<time+pair.d)
break;else
time+=pair.d;}
if(index==this.k.length)
return this.k[this.k.length-1].v;else{var baseValue=0;var key=this.k[index];if(index==0)
baseValue=(this.v===undefined?this._$.defV:this.v);else
baseValue=this.k[index-1].v;return key.interpolation(baseValue,(currentTime-time)/key.d);}}};}());JVRE.IP.Interpolation=new Class(function(){return{Extends:JVRE.Persistent,interpolation:function(baseValue,progress,key){throw new JVRE.Exception("pure virtual fucntion",JVRE.Error.E_NOTIMPL);}};}());JVRE.IP.Discrete=new Class(function(){return{Extends:JVRE.IP.Interpolation,_$pt:"IP.Discrete",interpolation:function(baseValue,progress,key){return baseValue;}};}());JVRE.IP.Linear=new Class(function(){return{Extends:JVRE.IP.Interpolation,_$pt:"IP.Linear",initialize:function(){this.parent();},interpolation:function(baseValue,progress,key){return(key.v-baseValue)*progress+baseValue;}};}());JVRE.IP.Bezier=new Class(function(){return{Extends:JVRE.IP.Interpolation,_$pt:"IP.Bezier",initialize:function(){this.parent();},interpolation:function(baseValue,progress,key){var t=progress;var r=1-progress;var p0=baseValue;var c1=key.property(JVRE.IP.Bezier.C1);var c2=key.property(JVRE.IP.Bezier.C2);var p1=key.v;if(c1===undefined&&c2===undefined)
throw new JVRE.Exception();else if(c2===undefined)
return(r*r)*p0+(2*r*t)*c1+(t*t)*p1;else
return(r*r*r)*p0+(3*r*r*t)*c1+(3*r*t*t)*c2+(t*t*t)*p1;}};}());JVRE.IP.Bezier.C1=new JVRE.DependencyProperty("IP:Bezier.C1",Number,JVRE.IP.Bezier,true);JVRE.IP.Bezier.C2=new JVRE.DependencyProperty("IP:Bezier.C2",Number,JVRE.IP.Bezier,true);JVRE.Source=new Class(function(){return{Extends:JVRE.Media,initialize:function(){this.parent();this._$=this._$||{};this._$._delayLoad=true;this._$._reSeek=3000;this._source=null;this._duration=null;},source:function(source){if(source==undefined)
return this._source;else
this._source=source;},duration:function(){return this._duration;},delayLoad:function(){return this._$._delayLoad;}};}());JVRE.Source.log=false;JVRE.Source.VSource=new Class(function(){return{Extends:JVRE.Source,initialize:function(){this.parent();this._$=this._$||{};this._width=null;this._height=null;},width:function(){return this._width;},height:function(){return this._height;},hitTest:function(x,y){var result={object:this,point:{x:x,y:y},box:{a:{x:0,y:0},b:{x:this._width,y:0},c:{x:this._width,y:this._height},d:{x:0,y:this._height}}};if(0<=x&&x<this._width&&0<=y&&y<this._height)
return result;else null;}};}());JVRE.Source.VMultiSource=new Class(function(){return{Extends:JVRE.Source.VSource,_$pt:"Source.VMultiSource",initialize:function(){this.parent();this._$=this._$||{};this._$._items=[];this._$._itemsType=[];},_unserialize:function(data){this.parent(data);this._update();},load:function(context){this.parent(context);this._$._loadStare=JVRE.Media.LoadState.Loaded;this._$._ready=true;if(JVRE.Source.log)
debug.debug("[JVRE.Source.MultiSource] load");this.fireEvent("sourceLoaded");this.fireEvent("sourceReady");},_update:function(){this._$._items.sort(function(itemA,itemB){var beginA=itemA.property(JVRE.BeginTime);var beginB=itemB.property(JVRE.BeginTime);return beginA-beginB;});},count:function(){return this._$._items.length;},items:function(index){return this._$._items[index];},push:function(item,begin){var found=false;for(var index=0;index<this._$._itemsType.length;++index){if(instanceOf(item,this._$._itemsType[index])){found=true;break;}}
if(found){item.property(JVRE.BeginTime,begin||0);var that=this;item.addEvent(JVRE.BeginTime._name+"_change",function(){that._update();});this._$._items.push(item);this._update();}
else
throw new JVRE.Exception("item invalid argument",JVRE.Error.E_INVALIDARG);},indexOf:function(item){return this._$._items.indexOf(item);},del:function(index,count){if(index>=this._$._items.length||index<0)
throw new JVRE.Exception("index invalid argument",JVRE.Error.E_INVALIDARG);count=count||1;if(index+count>this._$._items.length||count<1)
throw new JVRE.Exception("count invalid argument",JVRE.Error.E_INVALIDARG);for(var i=index;i<index+count;++i)
this._$._items[i].removeEvents(JVRE.BeginTime._name+"_change");this._$._items.splice(index,count);},duration:function(){var duration=0;var that=this;Array.each(this._$._items,function(item){var end=item.property(JVRE.BeginTime)+item.duration();if(duration<end)
duration=end;});return duration;},run:function(currentTime){this.parent(currentTime);if(this._$._currentTime>this.duration()){this._$._currentTime=0;this.fireEvent("sourceEnd");}
return 0;},currentTime:function(time){if(time===undefined){return this._$._currentTime;}
else{if(time<this.duration()){this._$._currentTime=time;this.fireEvent("sourceReady");}
else{this._$._currentTime=0;this.fireEvent("sourceEnd");}}},render:function(context){for(var index=0;index<this._$._items.length;++index){var item=this._$._items[index];var begin=item.property(JVRE.BeginTime);if(begin>this._$._currentTime)
break;var end=begin+item.duration();if(begin<=this._$._currentTime&&this._$._currentTime<end){if(this._customizedRender)
this._customizedRender(context,item,begin);else
item.render(context,this._$._currentTime-begin);}}},hitTest:function(x,y){var result={object:this,child:[]};if(this._$._currentTime!==null){for(var index=this._$._items.length-1;index>=0;--index){var item=this._$._items[index];var begin=item.property(JVRE.BeginTime);var end=begin+item.duration();if(begin<=this._$._currentTime&&this._$._currentTime<end){var obj=item.hitTest(this._$._context,this._$._currentTime-begin,x,y);if(obj!=null)
result.child.push(obj);}}}
if(result.child.length!=0)
return result;return null;}};}());JVRE.Source.VideoSource=new Class(function(){return{Extends:JVRE.Source.VSource,_$pt:"Source.VideoSource",initialize:function(){this.parent();this._$=this._$||{};this._$._video=null;this._$._bufferEnd=0;this._$._delayLoad=true;},_bindEvent:function(sourceUrl){var that=this;this._$.metadataLoadedCallback=function(e){if(JVRE.Source.log)
debug.debug("[JVRE.Source.VideoSource] Metadata loaded, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that._duration=that._$._video.duration;that._width=that._$._video.videoWidth;that._height=that._$._video.videoHeight;}
this._$.loadedCallback=function(e){if(JVRE.Source.log)
debug.debug("[JVRE.Source.VideoSource] Video loaded, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that._$._loadStare=JVRE.Media.LoadState.Loaded;that._$._ready=true;that.fireEvent("sourceLoaded");that.fireEvent("sourceReady");}
this._$.readyCallback=function(e){if(JVRE.Source.log)
debug.debug("[JVRE.Source.VideoSource] Video ready, event:"+e.type+" currentTime:"+that.currentTime()+" source:["+that._$._mediaID+"] "+sourceUrl);that._$._ready=true;that.fireEvent("sourceReady");}
this._$.notReadyCallback=function(e){if(JVRE.Source.log)
debug.debug("[JVRE.Source.VideoSource] Video waiting, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);if(that.$_loading!==true){that._$._ready=false;that.fireEvent("sourceNotReady");}}
this._$.stalledCallback=function(e){if(JVRE.Source.log)
debug.warn("[JVRE.Source.VideoSource] Video stalled, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that.fireEvent("sourceStalled");}
this._$.errorCallback=function(e){if(JVRE.Source.log)
debug.error("[JVRE.Source.VideoSource] Video error, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that._$._ready=false;that.fireEvent("sourceError");}
this._$.endCallback=function(e){if(JVRE.Source.log)
debug.debug("[JVRE.Source.VideoSource] Video end, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that._$._ready=true;that.fireEvent("sourceEnd");}
this._$._video.addEventListener('loadedmetadata',this._$.metadataLoadedCallback,false);if(JVRE.Browser.firefox)this._$._video.addEventListener('loadeddata',this._$.loadedCallback,false);else this._$._video.addEventListener('canplaythrough',this._$.loadedCallback,false);this._$._video.addEventListener('playing',this._$.readyCallback,false);this._$._video.addEventListener('seeked',this._$.readyCallback,false);this._$._video.addEventListener('seeking',this._$.notReadyCallback,false);if(!JVRE.Browser.firefox)this._$._video.addEventListener('waiting',this._$.notReadyCallback,false);this._$._video.addEventListener('stalled',this._$.stalledCallback,false);this._$._video.addEventListener('error',this._$.errorCallback,false);this._$._video.addEventListener('ended',this._$.endCallback,false);},_unbindEvent:function(){this._$._video.removeEventListener('loadedmetadata',this._$.metadataLoadedCallback,false);if(JVRE.Browser.firefox)this._$._video.removeEventListener('loadeddata',this._$.loadedCallback,false);else this._$._video.removeEventListener('canplaythrough',this._$.loadedCallback,false);this._$._video.removeEventListener('playing',this._$.readyCallback,false);this._$._video.removeEventListener('seeked',this._$.readyCallback,false);this._$._video.removeEventListener('seeking',this._$.notReadyCallback,false);if(!JVRE.Browser.firefox)this._$._video.removeEventListener('waiting',this._$.notReadyCallback,false);this._$._video.removeEventListener('stalled',this._$.stalledCallback,false);this._$._video.removeEventListener('error',this._$.errorCallback,false);this._$._video.removeEventListener('ended',this._$.endCallback,false);},reset:function(){this.parent();if(JVRE.Track.log)
debug.debug("[JVRE.Source.VideoSource] reset");this._unbindEvent();this._$._video.pause();this._$._video.src="";this._$._video=null;},load:function(context){this.parent(context);var that=this;if(JVRE.Source.log)
debug.debug("[JVRE.Source.VideoSource] Prepare load video source:["+this._$._mediaID+"] "+this._source);this._$._loadStare=JVRE.Media.LoadState.Loading;this.fireEvent("sourceLoading");var loadCallback=function(sourceUrl){if(JVRE.Source.log)
debug.debug("[JVRE.Source.VideoSource] Load video source:["+that._$._mediaID+"] "+sourceUrl);that._$._sourceUrl=sourceUrl;that._$._video=document.createElement('video');that._bindEvent(sourceUrl);that._$._video.preload="auto";that._$._video.src=sourceUrl;}
if(context.source_resolver)
context.source_resolver(this._source,loadCallback);else loadCallback(this._source);},networkIdle:function(){if(this._$._video)
return this._$._video.networkState==1;else return true;},run:function(currentTime){this.parent(currentTime);if(this._$._video.duration<currentTime){if(JVRE.Source.log)
debug.warn("[JVRE.Source.VideoSource] currentTime("+currentTime+") is out of range, duration"+this._$._video.duration);return 0;}
var context=this._$._context;var usync=this._$._currentTime-this._$._video.currentTime;if((usync>context.unsync_threshold)||(-context.unsync_threshold>usync)){var droppedFrame=this._$._video.webkitDroppedFrameCount;if(JVRE.Source.log)
debug.warn("[JVRE.Source.VideoSource] Source not sync:"+usync+" threshold:"+context.unsync_threshold+" source:["+this._$._mediaID+"] dropFrame:"+droppedFrame);this.fireEvent("sourceNotSync");}
return usync;},play:function(){if(JVRE.Source.log)
debug.debug("[JVRE.Source.VideoSource] play, currentTime:"+this._$._video.currentTime+" source:["+this._$._mediaID+"] "+this._$._sourceUrl);this._$._video.muted=true;this._$._video.play();},pause:function(){if(this._$._loadStare!=JVRE.Media.LoadState.Loaded)
return;if(JVRE.Source.log)
debug.debug("[JVRE.Source.VideoSource] pause, currentTime:"+this._$._video.currentTime+" source:["+this._$._mediaID+"] "+this._$._sourceUrl);this._$._video.pause();},currentTime:function(time){if(time===undefined){return this._$._video.currentTime;}
else{if(JVRE.Source.log)
debug.debug("[JVRE.Source.VideoSource] seek to "+time+" currentTime:"+this._$._video.currentTime+" source:["+this._$._mediaID+"] "+this._$._sourceUrl);if(time<this._$._video.duration){try{var that=this;setTime=function(){that._$._ready=false;that.fireEvent("sourceNotReady");if(!that._$._video.seekable||(that._$._video.seekable.start(0)<=time&&time<that._$._video.seekable.end(0))){that._$._video.currentTime=time;that._$._currentTime=time;}
else{if(that._$._video.seekable.start(0)>time){that._$._video.currentTime=0;setTimeout(setTime,that._$._reSeek);}
else{that._$._video.currentTime=that._$._video.seekable.end(0);that._$._currentTime=that._$._video.seekable.end(0);setTimeout(setTime,that._$._reSeek);}}};setTime();}
catch(e){if(JVRE.Source.log)
debug.error("[JVRE.Source.VideoSource] seek error to "+time+" currentTime:"+this._$._video.currentTime,e);}}
else{this._$._currentTime=0;this._$._video.currentTime=0;this.fireEvent("sourceEnd");}}},buffered:function(time){if(this._$._video&&this._$._video.buffered){var buffered=this._$._video.buffered;if(JVRE.Browser.ie){if(buffered.length>0){var newEnd=buffered.end(buffered.length-1);if(newEnd>this._$._bufferEnd){this._$._bufferEnd=newEnd;}}
if(0<=time&&time<this._$._bufferEnd)
return true;}
else if(JVRE.Browser.chrome||JVRE.Browser.firefox){for(var index=0;index<buffered.length;++index)
if(buffered.start(index)<=time&&time<buffered.end(index))
return true;}}
return false;},render:function(context){if(context.global_volume!=this._$._video.volume)
this._$._video.volume=context.global_volume;this._$._video.muted=false;context.target.drawImage(this._$._video,0,0);},sourceElement:function(){return this._$._video;}};}());JVRE.Source.ImageSource=new Class(function(){return{Extends:JVRE.Source.VSource,_$pt:"Source.ImageSource",initialize:function(){this.parent();this._$=this._$||{};this._$._image=null;this._duration=1;},reset:function(){this.parent();if(JVRE.Track.log)
debug.debug("[JVRE.Source.ImageSource] reset");this._$._image.removeEventListener('load',this._$.loadedCallback,false);this._$._image.removeEventListener('error',this._$.errorCallback,false);this._$._image=null;},load:function(context){this.parent(context);var that=this;if(JVRE.Source.log)
debug.debug("[JVRE.Source.ImageSource] Load image source:["+this._$._mediaID+"] "+this._source);var loadCallback=function(sourceUrl){that._$._image=document.createElement('img');that._$.loadedCallback=function(e){if(JVRE.Source.log)
debug.debug("[JVRE.Source.ImageSource] Image loaded, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that._$._ready=true;that._$._loadStare=JVRE.Media.LoadState.Loaded;that._width=that._$._image.width;that._height=that._$._image.height;that.fireEvent("sourceLoaded");that.fireEvent("sourceReady");}
that._$.errorCallback=function(e){if(JVRE.Source.log)
debug.error("[JVRE.Source.ImageSource] Image error, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that._$._ready=false;that.fireEvent("sourceError");}
that._$._image.addEventListener('load',that._$.loadedCallback,false);that._$._image.addEventListener('error',that._$.errorCallback,false);that.fireEvent("sourceLoading");that._$._image.src=sourceUrl;}
if(context.source_resolver)
context.source_resolver(this._source,loadCallback);else loadCallback(this._source);},duration:function(duration){if(duration==undefined)
return this._duration;else if(instanceOf(duration,Number)&&duration>0)
this._duration=duration;else throw new JVRE.Exception("duration invalid argument",JVRE.Error.E_INVALIDARG);},run:function(currentTime){this.parent(currentTime);if(this._$._currentTime>this._duration){this._$._currentTime=0;this.fireEvent("sourceEnd");}
return 0;},currentTime:function(time){if(time===undefined){return this._$._currentTime;}
else{if(time<this._duration){this._$._currentTime=time;this.fireEvent("sourceReady");}
else{this._$._currentTime=0;this.fireEvent("sourceEnd");}}},render:function(context){context.target.drawImage(this._$._image,0,0);},sourceElement:function(){return this._$._image;}};}());JVRE.Source.ASource=new Class(function(){return{Extends:JVRE.Source,initialize:function(){this.parent();}};}());JVRE.Source.AudioSource=new Class(function(){return{Extends:JVRE.Source.ASource,_$pt:"Source.AudioSource",initialize:function(){this.parent();this._$=this._$||{};this._$._audio=null;this._$._bufferEnd=0;this._$._delayLoad=true;},_bindEvent:function(sourceUrl){var that=this;this._$.metadataLoadedCallback=function(e){if(JVRE.Source.log)
debug.debug("[JVRE.Source.AudioSource] Metadata loaded, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that._duration=that._$._audio.duration;}
this._$.loadedCallback=function(e){if(JVRE.Source.log)
debug.debug("[JVRE.Source.AudioSource] Audio loaded, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that._$._loadStare=JVRE.Media.LoadState.Loaded;that._$._ready=true;that.fireEvent("sourceLoaded");that.fireEvent("sourceReady");}
this._$.readyCallback=function(e){if(JVRE.Source.log)
debug.debug("[JVRE.Source.AudioSource] Audio ready, event:"+e.type+" currentTime:"+that.currentTime()+" source:["+that._$._mediaID+"] "+sourceUrl);that._$._ready=true;that.fireEvent("sourceReady");}
this._$.notReadyCallback=function(e){if(JVRE.Source.log)
debug.debug("[JVRE.Source.AudioSource] Audio waiting, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);if(that.$_loading!==true){that._$._ready=false;that.fireEvent("sourceNotReady");}}
this._$.stalledCallback=function(e){if(JVRE.Source.log)
debug.warn("[JVRE.Source.AudioSource] Audio stalled, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that.fireEvent("sourceStalled");}
this._$.errorCallback=function(e){if(JVRE.Source.log)
debug.error("[JVRE.Source.AudioSource] Audio error, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that._$._ready=false;that.fireEvent("sourceError");}
this._$.endCallback=function(e){if(JVRE.Source.log)
debug.debug("[JVRE.Source.AudioSource] Audio end, event:"+e.type+" source:["+that._$._mediaID+"] "+sourceUrl);that._$._ready=true;that.fireEvent("sourceEnd");}
this._$._audio.addEventListener('loadedmetadata',this._$.metadataLoadedCallback,false);if(JVRE.Browser.firefox)this._$._audio.addEventListener('loadeddata',this._$.loadedCallback,false);else this._$._audio.addEventListener('canplaythrough',this._$.loadedCallback,false);this._$._audio.addEventListener('playing',this._$.readyCallback,false);this._$._audio.addEventListener('seeked',this._$.readyCallback,false);this._$._audio.addEventListener('seeking',this._$.notReadyCallback,false);if(!JVRE.Browser.firefox)this._$._audio.addEventListener('waiting',this._$.notReadyCallback,false);this._$._audio.addEventListener('stalled',this._$.stalledCallback,false);this._$._audio.addEventListener('error',this._$.errorCallback,false);this._$._audio.addEventListener('ended',this._$.endCallback,false);},_unbindEvent:function(){this._$._audio.removeEventListener('loadedmetadata',this._$.metadataLoadedCallback,false);if(JVRE.Browser.firefox)this._$._audio.removeEventListener('loadeddata',this._$.loadedCallback,false);else this._$._audio.removeEventListener('canplaythrough',this._$.loadedCallback,false);this._$._audio.removeEventListener('playing',this._$.readyCallback,false);this._$._audio.removeEventListener('seeked',this._$.readyCallback,false);this._$._audio.removeEventListener('seeking',this._$.notReadyCallback,false);if(!JVRE.Browser.firefox)this._$._audio.removeEventListener('waiting',this._$.notReadyCallback,false);this._$._audio.removeEventListener('stalled',this._$.stalledCallback,false);this._$._audio.removeEventListener('error',this._$.errorCallback,false);this._$._audio.removeEventListener('ended',this._$.endCallback,false);},reset:function(){this.parent();if(JVRE.Track.log)
debug.debug("[JVRE.Source.AudioSource] reset");this._unbindEvent();this._$._audio.pause();this._$._audio.src="";this._$._audio=null;},load:function(context){this.parent(context);if(JVRE.Source.log)
debug.debug("[JVRE.Source.AudioSource] Prepare load video source:["+this._$._mediaID+"] "+this._source);var that=this;this._$._loadStare=JVRE.Media.LoadState.Loading;this.fireEvent("sourceLoading");var loadCallback=function(sourceUrl){if(JVRE.Source.log)
debug.debug("[JVRE.Source.AudioSource] Load audio source:["+that._$._mediaID+"] "+sourceUrl);that._$._sourceUrl=sourceUrl;that._$._audio=document.createElement('audio');that._bindEvent(sourceUrl);that._$._audio.preload="auto";that._$._audio.src=sourceUrl;}
if(context.source_resolver)
context.source_resolver(this._source,loadCallback);else loadCallback(this._source);},networkIdle:function(){if(this._$._audio)
return this._$._audio.networkState==1;else return true;},run:function(currentTime){this.parent(currentTime);if(this._$._audio.duration<currentTime){if(JVRE.Source.log)
debug.warn("[JVRE.Source.AudioSource] currentTime("+currentTime+") is out of range, duration"+this._$._video.duration);return 0;}
var context=this._$._context;var usync=this._$._currentTime-this._$._audio.currentTime;if((usync>context.unsync_threshold)||(-context.unsync_threshold>usync)){if(JVRE.Source.log)
debug.warn("[JVRE.Source.AudioSource] Source not sync:"+usync+" threshold:"+context.unsync_threshold+" source:["+this._$._mediaID+"]");this.fireEvent("sourceNotSync");}
return usync;},play:function(){if(JVRE.Source.log)
debug.debug("[JVRE.Source.AudioSource] play, currentTime:"+this._$._audio.currentTime+" source:["+this._$._mediaID+"] "+this._$._sourceUrl);this._$._audio.muted=true;this._$._audio.play();},pause:function(){if(this._$._loadStare!=JVRE.Media.LoadState.Loaded)
return;if(JVRE.Source.log)
debug.debug("[JVRE.Source.AudioSource] pause, currentTime:"+this._$._audio.currentTime+" source:["+this._$._mediaID+"] "+this._$._sourceUrl);this._$._audio.pause();},currentTime:function(time){if(time===undefined){return this._$._audio.currentTime;}
else{if(JVRE.Source.log)
debug.debug("[JVRE.Source.AudioSource] seek to "+time+" currentTime:"+this._$._audio.currentTime+" source:["+this._$._mediaID+"] "+this._$._sourceUrl);if(time<this._$._audio.duration){try{var that=this;setTime=function(){that._$._ready=false;that.fireEvent("sourceNotReady");if(!that._$._audio.seekable||that._$._audio.seekable.start(0)<=time&&time<that._$._audio.seekable.end(0)){that._$._audio.currentTime=time;that._$._currentTime=time;}
else{if(that._$._audio.seekable.start(0)>time){that._$._audio.currentTime=0;setTimeout(setTime,that._$._reSeek);}
else{that._$._audio.currentTime=that._$._audio.seekable.end(0);that._$._currentTime=that._$._audio.seekable.end(0);setTimeout(setTime,that._$._reSeek);}}};setTime();}
catch(e){if(JVRE.Source.log)
debug.error("[JVRE.Source.AudioSource] seek error to "+time+" currentTime:"+this._$._audio.currentTime,e);}}
else{this._$._currentTime=0;this._$._audio.currentTime=0;this.fireEvent("sourceEnd");}}},buffered:function(time){if(this._$._audio&&this._$._audio.buffered){var buffered=this._$._audio.buffered;if(JVRE.Browser.ie){if(buffered.length>0){var newEnd=buffered.end(buffered.length-1);if(newEnd>this._$._bufferEnd){this._$._bufferEnd=newEnd;}}
if(0<=time&&time<this._$._bufferEnd)
return true;}
else if(JVRE.Browser.chrome||JVRE.Browser.firefox){for(var index=0;index<buffered.length;++index)
if(buffered.start(index)<=time&&time<buffered.end(index))
return true;}}
return false;},render:function(context){if(context.global_volume!=this._$._audio.volume)
this._$._audio.volume=context.global_volume;this._$._audio.muted=false;},sourceElement:function(){return this._$._audio;}};}());JVRE.VEffection=new Class(function(){return{_initializeEffection:function(){this._effects=[];},countEffect:function(){return this._effects.length;},getEffect:function(index){return this._effects[index];},indexOfEffect:function(clip){return this._effects.indexOf(clip);},pushEffect:function(effect){if(instanceOf(effect,JVRE.Effect.VEffect)){this._effects.push(effect);}
else throw new JVRE.Exception("effect invalid argument",JVRE.Error.E_INVALIDARG);},delEffect:function(index,count){if(index>=this._effects.length||index<0)
throw new JVRE.Exception("index invalid argument",JVRE.Error.E_INVALIDARG);count=count||1;if(index+count>this._effects.length||count<1)
throw new JVRE.Exception("count invalid argument",JVRE.Error.E_INVALIDARG);this._effects.splice(index,count);},_loadEffection:function(context){Array.each(this._effects,function(effect){effect.load(context);});},_renderEffect:function(context){context.target.save();var that=this;Array.each(this._effects,function(effect){effect.render(this._$._currentTime,context.target.canvas,context.target.canvas);});context.target.restore();}};}());JVRE.VTransformation=new Class(function(){return{_initializeTransformation:function(){this.posX=new JVRE.IP(0);this.posY=new JVRE.IP(0);this.scaleW=new JVRE.IP(1);this.scaleH=new JVRE.IP(1);this.shear=new JVRE.IP(0);this.rotateCenterX=new JVRE.IP(0);this.rotateCenterY=new JVRE.IP(0);this.rotateAngle=new JVRE.IP(0);this.alpha=new JVRE.IP(1);this.compositeOperation=new JVRE.IP("source-over");},_setTransformatContext:function(context){context.globalAlpha=this.alpha.value(this._$._currentTime);context.globalCompositeOperation=this.compositeOperation.value(this._$._currentTime);context.translate(this.posX.value(this._$._currentTime),this.posY.value(this._$._currentTime));context.transform(1,0,this.shear.value(this._$._currentTime),1,0,0);var rotateCenterX=this.rotateCenterX.value(this._$._currentTime);var rotateCenterY=this.rotateCenterY.value(this._$._currentTime);context.translate(rotateCenterX,rotateCenterY);context.rotate(this.rotateAngle.value(this._$._currentTime));context.translate(-rotateCenterX,-rotateCenterY);context.scale(this.scaleW.value(this._$._currentTime),this.scaleH.value(this._$._currentTime));},_tranConvert:function(currentTime){var posX=this.posX.value(currentTime);var posY=this.posY.value(currentTime);var shear=this.shear.value(currentTime);var rotateCenterX=this.rotateCenterX.value(currentTime);var rotateCenterY=this.rotateCenterY.value(currentTime);var angle=this.rotateAngle.value(currentTime);var sin=Math.sin(angle),cos=Math.cos(angle);var scaleW=this.scaleW.value(currentTime);var scaleH=this.scaleH.value(currentTime);var convert=function(x,y){x*=scaleW;y*=scaleH;x+=rotateCenterX;y+=rotateCenterY;var newX=x*cos-y*sin-rotateCenterX;var newY=x*sin+y*cos-rotateCenterY;x=newX;y=newY;x+=shear*y;x+=posX;y+=posY;return{x:x,y:y};}
var invert=function(x,y){x-=posX;y-=posY;x-=shear*y;x-=rotateCenterX;y-=rotateCenterY;var newX=x*cos+y*sin+rotateCenterX;var newY=-x*sin+y*cos+rotateCenterY;x=newX;y=newY;x/=scaleW;y/=scaleH;return{x:x,y:y};}
return{convert:convert,invert:invert};}};}());JVRE.AVolumeControl=new Class(function(){return{_initializeVolumeControl:function(){this.volume=new JVRE.IP(1);},_mixVolume:function(context){return this.volume.value(this._$._currentTime)*context.global_volume;}};}());JVRE.Source.TextItem=new Class(function(){return{Extends:JVRE.Persistent,Implements:JVRE.DependencyObject,_$pt:"Source.TextItem",initialize:function(){this.parent();this._$=this._$||{};this.posX=new JVRE.IP(0);this.posY=new JVRE.IP(0);this.scaleW=new JVRE.IP(1);this.scaleH=new JVRE.IP(1);this.shear=new JVRE.IP(0);this.rotateCenterX=new JVRE.IP(0);this.rotateCenterY=new JVRE.IP(0);this.rotateAngle=new JVRE.IP(0);this.font=new JVRE.IP('sans-serif');this.fontStyle=new JVRE.IP('');this.fontSize=new JVRE.IP(10);this.text=new JVRE.IP("");this.textLineHeight=new JVRE.IP(1.2);this.textColorR=new JVRE.IP(255);this.textColorG=new JVRE.IP(255);this.textColorB=new JVRE.IP(255);this.textColorA=new JVRE.IP(1);this.textBGColorR=new JVRE.IP(0);this.textBGColorG=new JVRE.IP(0);this.textBGColorB=new JVRE.IP(0);this.textBGColorA=new JVRE.IP(0);this.textBoxColorR=new JVRE.IP(0);this.textBoxColorG=new JVRE.IP(0);this.textBoxColorB=new JVRE.IP(0);this.textBoxColorA=new JVRE.IP(0);this.textBoxWidth=new JVRE.IP(1);this.textAlign=new JVRE.IP("center");this.textBaseline=new JVRE.IP("bottom");this._duration=1;},duration:function(duration){if(duration===undefined)
return this._duration;else if(instanceOf(duration,Number)&&duration>0)
this._duration=duration;else throw new JVRE.Exception("duration invalid argument",JVRE.Error.E_INVALIDARG);},height:function(context,currentTime){return this.fontSize.value(currentTime)*this.textLineHeight.value(currentTime);},width:function(context,currentTime){context.target.save();var fontSize=this.fontSize.value(currentTime);var fontStyle=this.fontStyle.value(currentTime);context.target.font=fontStyle+" "+fontSize.toString()+"px "+this.font.value(currentTime);context.target.textAlign=this.textAlign.value(currentTime);context.target.textBaseline=this.textBaseline.value(currentTime);var metrics=context.target.measureText(this.text.value(currentTime));context.target.restore();return metrics.width+4;},render:function(context,currentTime){context.target.save();context.target.translate(this.posX.value(currentTime),this.posY.value(currentTime));context.target.transform(1,0,this.shear.value(currentTime),1,0,0);var rotateCenterX=this.rotateCenterX.value(currentTime);var rotateCenterY=this.rotateCenterY.value(currentTime);context.target.translate(rotateCenterX,rotateCenterY);context.target.rotate(this.rotateAngle.value(currentTime));context.target.translate(-rotateCenterX,-rotateCenterY);context.target.scale(this.scaleW.value(currentTime),this.scaleH.value(currentTime));var fontSize=this.fontSize.value(currentTime);var textAlign=this.textAlign.value(currentTime);context.target.fillStyle="rgba("+
this.textBGColorR.value(currentTime)+","+
this.textBGColorG.value(currentTime)+","+
this.textBGColorB.value(currentTime)+","+
this.textBGColorA.value(currentTime)+")";var width=this.width(context,currentTime);var x=0,y=-fontSize*this.textLineHeight.value(currentTime);switch(textAlign){case"right":case"end":x-=width;break;case"center":x-=width/2;break;default:break;}
var height=this.height(context,currentTime);context.target.beginPath();context.target.rect(x,y,width,height);context.target.fill();context.target.closePath();context.target.strokeStyle="rgba("+
this.textBoxColorR.value(currentTime)+","+
this.textBoxColorG.value(currentTime)+","+
this.textBoxColorB.value(currentTime)+","+
this.textBoxColorA.value(currentTime)+")";context.target.lineWidth=this.textBoxWidth.value(currentTime);context.target.strokeRect(x,y,width,height);var fontStyle=this.fontStyle.value(currentTime);context.target.font=fontStyle+" "+fontSize.toString()+"px "+this.font.value(currentTime);context.target.textAlign=textAlign;context.target.textBaseline=this.textBaseline.value(currentTime);context.target.fillStyle="rgba("+
this.textColorR.value(currentTime)+","+
this.textColorG.value(currentTime)+","+
this.textColorB.value(currentTime)+","+
this.textColorA.value(currentTime)+")";var textBiasX=-1;var textBiasY=Math.max(0,0.05*fontSize-2);context.target.fillText(this.text.value(currentTime),-textBiasX,-textBiasY);context.target.restore();},tranConvert:function(context,currentTime,width,height){var posX=this.posX.value(currentTime);var posY=this.posY.value(currentTime);var shear=this.shear.value(currentTime);var rotateCenterX=this.rotateCenterX.value(currentTime);var rotateCenterY=this.rotateCenterY.value(currentTime);var angle=this.rotateAngle.value(currentTime);var sin=Math.sin(angle),cos=Math.cos(angle);var scaleW=this.scaleW.value(currentTime);var scaleH=this.scaleH.value(currentTime);var textAlign=this.textAlign.value(currentTime);var alignWidth=0;switch(textAlign){case"right":case"end":alignWidth+=width;break;case"center":alignWidth+=width/2;break;default:break;}
var convert=function(x,y){x-=alignWidth;y-=height;x*=scaleW;y*=scaleH;x-=rotateCenterX;y-=rotateCenterY;var newX=x*cos-y*sin+rotateCenterX;var newY=x*sin+y*cos+rotateCenterY;x=newX;y=newY;x+=shear*y;x+=posX;y+=posY;return{x:x,y:y};}
var invert=function(x,y){x-=posX;y-=posY;x-=shear*y;x-=rotateCenterX;y-=rotateCenterY;var newX=x*cos+y*sin+rotateCenterX;var newY=-x*sin+y*cos+rotateCenterY;x=newX;y=newY;x/=scaleW;y/=scaleH;x+=alignWidth;y+=height;return{x:x,y:y};}
return{convert:convert,invert:invert};},hitTest:function(context,currentTime,x,y){var width=this.width(context,currentTime);var height=this.height(context,currentTime);var compute=this.tranConvert(context,currentTime,width,height);var result=compute.invert(x,y);if(0<=result.x&&result.x<width&&0<=result.y&&result.y<height){return{object:this,point:result,tran:compute,box:{a:compute.convert(0,0),b:compute.convert(width,0),c:compute.convert(width,height),d:compute.convert(0,height)}}}
else
return null;}}}());JVRE.Source.TextSource=new Class(function(){return{Extends:JVRE.Source.VMultiSource,_$pt:"Source.TextSource",initialize:function(){this.parent();this._$=this._$||{};this._$._itemsType=[JVRE.Source.TextItem];this._texts=this._$._items;},texts:function(index){return this._texts[index];},_unserialize:function(data){this.parent(data);this._$._items=this._texts;}};}());JVRE.Effect=new Class(function(){return{Extends:JVRE.Persistent,Implements:JVRE.DependencyObject,initialize:function(){this.parent();this._$=this._$||{};this._$._currentTime=0;this._$._ready=false;},init:function(context){throw new JVRE.Exception("pure virtual fucntion",JVRE.Error.E_NOTIMPL);},render:function(context){throw new JVRE.Exception("pure virtual fucntion",JVRE.Error.E_NOTIMPL);}};}());JVRE.Effect.log=false;JVRE.Effect.VEffect=new Class(function(){return{Extends:JVRE.Effect,_$pt:"Effect.VEffect",initialize:function(){this.parent();this._$=this._$||{};this._$._type=JVRE.Effect.VEffect.Type.None;this._$._canvas=null;this._$._context=null;this._$._program=null;this._$._squareBuffer=null;this._$._texture=null;this._$._vShaderCode="precision highp float; attribute vec3 aVertexPosition; uniform mat4 uMVMatrix; uniform mat4 uPMatrix; void main(void) { gl_Position = uPMatrix * uMVMatrix * vec4(aVertexPosition, 1.0); }";this._$._pShaderCode="precision highp float; uniform vec2 resolution; uniform sampler2D tex; void main(void) { gl_FragColor = texture2D(tex, gl_FragCoord.xy / resolution.xy); }";},loadShader:function(shaderCode,type){var gl=this._$._context;var shader=gl.createShader(type);gl.shaderSource(shader,shaderCode);gl.compileShader(shader);if(!gl.getShaderParameter(shader,gl.COMPILE_STATUS)){var log=gl.getShaderInfoLog(shader);if(JVRE.Source.log)
debug.debug("[JVRE.Effect.WGLEffect] Compile shader fail, "+log);throw new JVRE.Exception("Compile shader fail "+log,JVRE.Error.E_FAIL);}
return shader;},initShaders:function(){var gl=this._$._context;var vShader=this.loadShader(this._$._vShaderCode,gl.VERTEX_SHADER);var pShader=this.loadShader(this._$._pShaderCode,gl.FRAGMENT_SHADER);var program=this._$._program=gl.createProgram();gl.attachShader(program,vShader);gl.attachShader(program,pShader);gl.linkProgram(program);if(!gl.getProgramParameter(program,gl.LINK_STATUS))
throw new JVRE.Exception("Link program",JVRE.Error.E_FAIL);gl.useProgram(program);program.aVertexPositionL=gl.getAttribLocation(program,"aVertexPosition");gl.enableVertexAttribArray(program.aVertexPositionL);program.pMatrixUniformL=gl.getUniformLocation(program,"uPMatrix");program.mvMatrixUniformL=gl.getUniformLocation(program,"uMVMatrix");program.resolutionL=gl.getUniformLocation(program,"resolution");program.currentTimeL=gl.getUniformLocation(program,"currentTime");program.texL=gl.getUniformLocation(program,"tex");return program;},initBuffers:function(){var gl=this._$._context;var program=this._$._program;var squareBuffer=this._$._squareBuffer=gl.createBuffer();gl._bindEventBuffer(gl.ARRAY_BUFFER,squareBuffer);vertices=[-1.0,-1.0,1.0,-1.0,-1.0,1.0,1.0,-1.0,1.0,1.0,-1.0,1.0];gl.bufferData(gl.ARRAY_BUFFER,new Float32Array(vertices),gl.STATIC_DRAW);squareBuffer.itemSize=2;squareBuffer.numItems=6;gl.useProgram(program);gl._bindEventBuffer(gl.ARRAY_BUFFER,squareBuffer);gl.vertexAttribPointer(program.aVertexPositionL,squareBuffer.itemSize,gl.FLOAT,false,0,0);return squareBuffer;},initViewport:function(){var gl=this._$._context;var program=this._$._program;gl.viewport(0,0,this._$._canvas.width,this._$._canvas.height);gl.clear(gl.COLOR_BUFFER_BIT|gl.DEPTH_BUFFER_BIT);var pMatrix=mat4.create();mat4.ortho(-1,1,-1,1,0,0.1,pMatrix);var mvMatrix=mat4.create();mat4.identity(mvMatrix);gl.useProgram(program);gl.uniformMatrix4fv(program.pMatrixUniformL,false,pMatrix);gl.uniformMatrix4fv(program.mvMatrixUniformL,false,mvMatrix);gl.uniform2f(program.resolutionL,this._$._canvas.width,this._$._canvas.height);},load:function(context){this._$._ready=false;this._$._canvas=document.createElement('canvas');this._$._canvas.height=context.height;this._$._canvas.width=context.width;if(context.render_type==JVRE.Effect.VEffect.Type.WebGL){if(this._$._pShaderCode===null)
throw new JVRE.Exception("WebGL type effect not implement",JVRE.Error.E_NOTIMPL);var gl=this._$._context=this._$._canvas.getContext("experimental-webgl");if(this._$._context===null){throw new JVRE.Exception("Get WebGL context fail",JVRE.Error.E_FAIL);}
this.initShaders();this.initBuffers();this.initViewport();var program=this._$._program;var squareBuffer=this._$._squareBuffer
gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL,true);gl.clearColor(0.0,0.0,0.0,1.0);gl.enable(gl.DEPTH_TEST);this._$._type=JVRE.Effect.VEffect.Type.WebGL;}
else if(context.render_type==JVRE.Effect.VEffect.Type.Canvas2D){if(this.renderCanvas2D===null)
throw new JVRE.Exception("Canvas2D  type effect not implement",JVRE.Error.E_NOTIMPL);this._$._type=JVRE.Effect.VEffect.Type.Canvas2D;}
else throw new JVRE.Exception("type not implement",JVRE.Error.E_NOTIMPL);this._$._ready=true;},loadTexture:function(source){var gl=this._$._context;var texture=gl.createTexture();gl.enable(gl.TEXTURE_2D);gl._bindEventTexture(gl.TEXTURE_2D,texture);gl.texImage2D(gl.TEXTURE_2D,0,gl.RGBA,gl.RGBA,gl.UNSIGNED_BYTE,source);gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.LINEAR);gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.LINEAR);gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.CLAMP_TO_EDGE);gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.CLAMP_TO_EDGE);gl._bindEventTexture(gl.TEXTURE_2D,null);return texture;},renderWebGL:function(source,target){var gl=this._$._context;var program=this._$._program;var squareBuffer=this._$._squareBuffer;gl.useProgram(program);if(program.currentTimeL!=null)
gl.uniform1f(program.currentTimeL,this._$._currentTime);var texture=this.loadTexture(source);gl.uniform1i(program.texL,0);gl.activeTexture(gl.TEXTURE0);gl._bindEventTexture(gl.TEXTURE_2D,texture);gl.clear(gl.COLOR_BUFFER_BIT|gl.DEPTH_BUFFER_BIT);gl.drawArrays(gl.TRIANGLES,0,squareBuffer.numItems);var context=target.getContext('2d');context.fillRect(0,0,target.width,target.height);context.drawImage(this._$._canvas,0,0);gl.deleteTexture(texture);},renderCanvas2D:null,render:function(currentTime,source,target){this._$._currentTime=currentTime;if(this._$._type==JVRE.Effect.VEffect.Type.WebGL)
this.renderWebGL(source,target);else if(this._$._type==JVRE.Effect.VEffect.Type.Canvas2D)
this.renderCanvas2D(source,target);else throw new JVRE.Exception("type not implement",JVRE.Error.E_NOTIMPL);}};}());JVRE.Effect.VEffect.Type={None:0,WebGL:1,Canvas2D:2};JVRE.Effect.ReverseEffect=new Class(function(){return{Extends:JVRE.Effect.VEffect,_$pt:"Effect.ReverseEffect",initialize:function(){this.parent();this._$._pShaderCode="precision highp float; uniform vec2 resolution; uniform sampler2D tex; void main(void) { gl_FragColor = vec4(1.0, 1.0, 1.0, 0.0) - texture2D(tex, gl_FragCoord.xy / resolution.xy); }";}};}());JVRE.Clip=new Class(function(){return{Extends:JVRE.Media,Implements:JVRE.AVolumeControl,initialize:function(){this.parent();this._initializeVolumeControl();this._$=this._$||{};this._$._rangeMap=[];this._$._currentRange=null;this._$._relativeTime=null;this._source=null;this._ranges=[];},source:function(source){if(source==undefined)
return this._source;else if(instanceOf(source,this._sourceClass)&&(source.context()===null||source.context()===this.context())){this._unbindEvent(this._source);this._source=source;this._bindEvent(this._source);this._update();if(this._source.context()===null&&this.context()!==null){this._$._ready=false;this._$._loadStare=JVRE.Media.LoadState.None;}}
else throw new JVRE.Exception("source invalid argument",JVRE.Error.E_INVALIDARG);},_bindEvent:function(source){var that=this;source.addEvent("sourceLoading",this._$.loadingCallback=function(){that._$._ready=false;that._$._loadStare=JVRE.Media.LoadState.Loading;that.fireEvent("sourceLoading");});source.addEvent("sourceLoaded",this._$.loadedCallback=function(){that._$._ready=true;that._$._loadStare=JVRE.Media.LoadState.Loaded;that._schedule();that.fireEvent("sourceLoaded");});source.addEvent("sourceReady",this._$.readyCallback=function(){that._$._ready=true;that.fireEvent("sourceReady");});source.addEvent("sourceNotReady",this._$.notReadyCallback=function(){that._$._ready=false;that.fireEvent("sourceNotReady");});source.addEvent("sourceNotSync",this._$.notSyncCallback=function(){that.fireEvent("sourceNotSync");});source.addEvent("sourceStalled",this._$.stalledCallback=function(){that.fireEvent("sourceStalled");});source.addEvent("sourceError",this._$.errorCallback=function(){that._$._ready=false;that.fireEvent("sourceError");});},_unbindEvent:function(source){if(source){source.removeEvent("sourceLoading",this._$.loadingCallback);source.removeEvent("sourceLoaded",this._$.loadedCallback);source.removeEvent("sourceReady",this._$.readyCallback);source.removeEvent("sourceNotReady",this._$.notReadyCallback);source.removeEvent("sourceNotSync",this._$.notSyncCallback);source.removeEvent("sourceStalled",this._$.stalledCallback);source.removeEvent("sourceError",this._$.errorCallback);}},dump:function(){var clip=$("<div/>").css({border:0,position:"absolute"});clip[0].associate=this;var style=$("<style>"+"div[type='clip']  { background-color: rgba(204, 255, 204, 0.5); }"+"div.ui-selected[type='clip']  { background-color: rgba(255, 255, 0, 0.8); }"+"</style>");var div=$("<div type='clip'/>").css({border:0,color:"#000000","font-size":9,height:60,width:this.duration()*20}).append(this.property(JVRE.BeginTime)+"("+this.duration()+") ID"+this.mediaID());var offset=0;Array.each(this._ranges,function(range,index){div.append($("<div type='range'/>").css({border:0,position:"absolute",color:"#000000","font-size":9,"background-color":index%2?"rgba(0, 204, 255, 0.5)":"rgba(0, 153, 255, 0.5)",height:40,width:range.duration()*20,left:offset*20}).attr("class","ui-widget-content").append(offset+"["+range.begin()+"-"+range.end()+"]"));offset+=range.duration();});if(clip.selectable!==undefined)
clip.selectable();clip.append(style);clip.append(div);return clip;},_unserialize:function(data){this.parent(data);this._update();this._bindEvent(this._source);},_update:function(){this._$._rangeMap=[];var begin=0;var that=this;Array.each(this._ranges,function(range){that._$._rangeMap.push(begin);begin+=range.duration();});this._$._rangeMap.push(begin);this._$._currentRange=null;},count:function(){return this._ranges.length;},ranges:function(index){return this._ranges[index];},indexOf:function(range){return this._ranges.indexOf(range);},push:function(range){if(instanceOf(range,JVRE.Range)){this._ranges.push(range);this._update();}
else throw new JVRE.Exception("range invalid argument",JVRE.Error.E_INVALIDARG);},del:function(index,count){if(index>=this._ranges.length||index<0)
throw new JVRE.Exception("index invalid argument",JVRE.Error.E_INVALIDARG);count=count||1;if(index+count>this._ranges.length||count<1)
throw new JVRE.Exception("count invalid argument",JVRE.Error.E_INVALIDARG);this._ranges.splice(index,count);this._update();},duration:function(){var duration=0;Array.each(this._ranges,function(range){duration+=range.duration();});return duration;},_schedule:function(){var currentRange=null;for(var index=0;index<this._$._rangeMap.length;++index){if(this._$._currentTime>=this._$._rangeMap[index]){currentRange=index;}
else
break;}
if(currentRange<this._$._rangeMap.length-1){var offset=this._$._currentTime-this._$._rangeMap[currentRange];this._$._relativeTime=this._ranges[currentRange].begin()+offset;if(this._$._currentRange!==currentRange){if(JVRE.Clip.log)
debug.debug("[JVRE.Clip] Range change, currentTime:"+this._$._currentTime);this._$._currentRange=currentRange;if(this._source.duration()>this._$._relativeTime)
this._source.currentTime(this._$._relativeTime);}}
else{this._$._currentTime=0;this._$._currentRange=null;this._source.pause();this.fireEvent("sourceReady");this.fireEvent("sourceEnd");}},run:function(currentTime){this.parent(currentTime);this._schedule();if(this._source.loadStare()==JVRE.Media.LoadState.Loaded)
return this._source.run(this._$._relativeTime);else
return 0;},reset:function(){this.parent();if(JVRE.Track.log)
debug.debug("[JVRE.Clip] reset");this._$._currentRange=null;this._$._relativeTime=null;this._source.reset();},delayLoad:function(){return this._source.delayLoad();},load:function(context){this.parent(context);this._$._ready=false;this._$._loadStare=JVRE.Media.LoadState.Loading;this._source.load(this._$._context);},networkIdle:function(){if(this._source)
return this._source.networkIdle();else return true;},play:function(){if(JVRE.Clip.log)
debug.debug("[JVRE.Clip] play, currentTime:"+this._$._currentTime);this._source.play();},pause:function(){if(this._$._loadStare==JVRE.Media.LoadState.None)
return;if(JVRE.Clip.log)
debug.debug("[JVRE.Clip] pause, currentTime:"+this._$._currentTime);this._source.pause();},currentTime:function(time){if(time===undefined){return this._$._currentTime;}
else{if(JVRE.Clip.log)
debug.debug("[JVRE.Clip] seek, currentTime:"+time);this._$._currentTime=time;this._$._currentRange=null;this._schedule();}},buffered:function(time){if(this._source.loadStare()!=JVRE.Media.LoadState.Loaded)
return false;var range=null;for(var index=0;index<this._$._rangeMap.length;++index){if(time>=this._$._rangeMap[index]){range=index;}
else
break;}
if(range!==null&&range<this._$._rangeMap.length-1){var offset=time-this._$._rangeMap[range];relativeTime=this._ranges[range].begin()+offset;if(this._source.duration()>=relativeTime)
return this._source.buffered(relativeTime);else
return true;}
return false;},render:function(context){var orgVolume=context.global_volume;context.global_volume=this._mixVolume(context);this._source.render(context);context.global_volume=orgVolume;}};}());JVRE.Clip.log=false;JVRE.Clip.VClip=new Class(function(){return{Extends:JVRE.Clip,Implements:[JVRE.VTransformation,JVRE.VEffection],_$pt:"Clip.VClip",_sourceClass:JVRE.Source.VSource,initialize:function(){this.parent();this._initializeTransformation();this._initializeEffection();},load:function(context){this.parent(context);this._loadEffection(context);},render:function(context){context.target.save();if(context.clip_transformation)
this._setTransformatContext(context.target);this.parent(context);if(context.clip_effection)
this._renderEffect(context);context.target.restore();},hitTest:function(x,y){var compute=this._tranConvert(this._$._currentTime);var xy=compute.invert(x,y);var obj=this._source.hitTest(xy.x,xy.y);if(obj!=null){var convert=function(obj){if(obj.box){obj.box.a=compute.convert(obj.box.a.x,obj.box.a.y);obj.box.b=compute.convert(obj.box.b.x,obj.box.b.y);obj.box.c=compute.convert(obj.box.c.x,obj.box.c.y);obj.box.d=compute.convert(obj.box.d.x,obj.box.d.y);}
if(obj.child){for(var index=0;index<obj.child.length;++index)
convert(obj.child[index]);}
return obj;}
return{object:this,tran:compute,child:[convert(obj)]};}
return null;}};}());JVRE.Clip.AClip=new Class(function(){return{Extends:JVRE.Clip,_$pt:"Clip.AClip",_sourceClass:JVRE.Source.ASource,initialize:function(){this.parent();}};}());JVRE.Track=new Class(function(){return{Extends:JVRE.Media,Implements:JVRE.AVolumeControl,initialize:function(){this.parent();this._initializeVolumeControl();this._$=this._$||{};this._$._currentClip=null;this._$._previousClip=null;this._clips=[];},isPresent:function(){var all=true;if(this._$._currentClip==null&&this._$._previousClip==null)
all=false;return all;},_allReady:function(){var all=false;if((this._$._currentClip==null||this._$._currentClip!=null&&this._clips[this._$._currentClip].isReady())&&(this._$._previousClip==null||this._$._previousClip!=null&&this._clips[this._$._previousClip].isReady()))
all=true;return all;},_allLoading:function(){var all=false;if((this._$._currentClip==null||this._clips[this._$._currentClip].loadStare()==JVRE.Media.LoadState.Loading)&&(this._$._previousClip==null||this._clips[this._$._previousClip].loadStare()==JVRE.Media.LoadState.Loading))
all=true;return all;},_isLoaded:function(index){return index!==null&&this._clips[index].loadStare()==JVRE.Media.LoadState.Loaded;},_allLoaded:function(){var all=false;if((this._$._currentClip==null||this._isLoaded(this._$._currentClip))&&(this._$._previousClip==null||this._isLoaded(this._$._previousClip)))
all=true;return all;},_bindEvent:function(clip){var that=this;clip.addEvent(JVRE.BeginTime._name+"_change",function(){that._update();that._schedule();});clip.addEvent("sourceLoading",this._$.loadingCallback=function(){if(that._allLoading()){if(JVRE.Track.log)
debug.warn("[JVRE.Track] loading source:["+clip.mediaID()+"]");that._$._ready=false;that._$._loadStare=JVRE.Media.LoadState.Loading;if(that.isPresent())
that.fireEvent("sourceLoading");}});clip.addEvent("sourceLoaded",this._$.loadedCallback=function(){if(that._allLoaded()){if(JVRE.Track.log)
debug.warn("[JVRE.Track] loaded source:["+clip.mediaID()+"]");that._$._ready=true;var oldState=that._$._loadStare;that._$._loadStare=JVRE.Media.LoadState.Loaded;if(that.isPresent()&&oldState==JVRE.Media.LoadState.Loading)
that.fireEvent("sourceLoaded");that._schedule();}});clip.addEvent("sourceReady",this._$.readyCallback=function(){that._$._ready=true;if(that._allLoaded()&&that._allReady()){if(JVRE.Track.log)
debug.warn("[JVRE.Track] ready source:["+clip.mediaID()+"]");if(that.isPresent())
that.fireEvent("sourceReady");}});clip.addEvent("sourceNotReady",this._$.notReadyCallback=function(){that._$._ready=false;if(that._allLoaded()&&!that._allReady()){if(JVRE.Track.log)
debug.warn("[JVRE.Track] notReady source:["+clip.mediaID()+"]");if(that.isPresent())
that.fireEvent("sourceNotReady");}});clip.addEvent("sourceNotSync",this._$.notSyncCallback=function(){that.fireEvent("sourceNotSync");});clip.addEvent("sourceStalled",this._$.stalledCallback=function(){that.fireEvent("sourceStalled");});clip.addEvent("sourceError",this._$.errorCallback=function(){that._$._ready=false;that.fireEvent("sourceError");});},_unbindEvent:function(clip){if(clip){clip.removeEvents(JVRE.BeginTime._name+"_change");clip.removeEvent("sourceLoading",this._$.loadingCallback);clip.removeEvent("sourceLoaded",this._$.loadedCallback);clip.removeEvent("sourceReady",this._$.readyCallback);clip.removeEvent("sourceNotReady",this._$.notReadyCallback);clip.removeEvent("sourceNotSync",this._$.notSyncCallback);clip.removeEvent("sourceStalled",this._$.stalledCallback);clip.removeEvent("sourceError",this._$.errorCallback);}},dump:function(){var track=$("<div/>").css({border:0,position:"relative"});track[0].associate=this;var style=$("<style>"+"div[type='track'] { background-color: #CC9933; }"+"div.ui-selected[type='track'] { background-color: rgba(255, 0, 0, 0.8); }"+"</style>");var div=$("<div type='track'/>").css({border:0,color:"#000000","font-size":9,height:80,width:this.duration()?this.duration()*20:""}).append("("+this.duration()+") ID"+this.mediaID());track[0].associate=this;Array.each(this._clips,function(clip){div.append(clip.dump().css("left",clip.property(JVRE.BeginTime)*20));});if(track.selectable!==undefined)
track.selectable();track.append(style);track.append(div);return track;},_unserialize:function(data){this.parent(data);this._update();var that=this;Array.each(this._clips,function(clip){that._bindEvent(clip);});},_update:function(){this._clips.sort(function(clipA,clipB){var beginA=clipA.property(JVRE.BeginTime);var beginB=clipB.property(JVRE.BeginTime);return beginA-beginB;});if(this._$._previousClip!==null)
this._$._previousClip=null;if(this._$._currentClip!==null)
this._$._currentClip=null;if(this._$._context!=null)
this._schedule();},count:function(){return this._clips.length;},clips:function(index){return this._clips[index];},push:function(clip,begin){if(instanceOf(clip,this._sourceClass)&&(clip.context()===null||clip.context()===this.context())){clip.property(JVRE.BeginTime,begin||0);this._clips.push(clip);this._bindEvent(clip);this._update();}
else
throw new JVRE.Exception("clip invalid argument",JVRE.Error.E_INVALIDARG);},indexOf:function(clip){return this._clips.indexOf(clip);},del:function(index,count){if(index>=this._clips.length||index<0)
throw new JVRE.Exception("index invalid argument",JVRE.Error.E_INVALIDARG);count=count||1;if(index+count>this._clips.length||count<1)
throw new JVRE.Exception("count invalid argument",JVRE.Error.E_INVALIDARG);for(var i=index;i<index+count;++i){this._unbindEvent(this._clips[i]);if(this._clips[i].isReady())
this._clips[i].pause();}
this._clips.splice(index,count);this._update();},duration:function(){var duration=0;Array.each(this._clips,function(clip){var newDuration=clip.property(JVRE.BeginTime)+clip.duration();if(duration<newDuration)
duration=newDuration;});return duration;},networkIdle:function(){if(this._clips.length!=0){for(var index=0;index<this._clips.length;++index){if(this._clips[index].networkIdle()==false)
return false;}
return true;}
else return true;},_schedule:function(){var previousClip=null;var currentClip=null;for(var index=0;index<this._clips.length;++index){var begin=this._clips[index].property(JVRE.BeginTime);var end=begin+this._clips[index].duration();if(begin<=this._$._currentTime&&this._$._currentTime<end){previousClip=currentClip;currentClip=index;}}
var preClip=null;if(this._$._currentClip!==null&&this._$._currentClip+1<this._clips.length)
var preClip=this._clips[this._$._currentClip+1];else if(this._clips.length!=0)
preClip=this._clips[0];if(preClip!=null){var begin=preClip.property(JVRE.BeginTime);var end=begin+preClip.duration();if(begin-this._$._context.preload_time<this._$._currentTime&&end<this._$._currentTime){if(preClip.loadStare()==JVRE.Media.LoadState.None){if(JVRE.Track.log)
debug.debug("[JVRE.Track] Preload clip, currentTime:"+this._$._currentTime);preClip.load(this._$._context);}
else if(preClip.loadStare()==JVRE.Media.LoadState.Loaded&&preClip.currentTime()!=0){if(JVRE.Track.log)
debug.debug("[JVRE.Track] Preseek clip, currentTime:"+this._$._currentTime);preClip.currentTime(0);preClip.pause();}}}
if(this.networkIdle()){var firstNotLoadedClip=null,notLoadedClip=null;var loading=false;for(var index=0;index<this._clips.length;++index){var state=this._clips[index].loadStare();if(state==JVRE.Media.LoadState.None){if(!firstNotLoadedClip)
firstNotLoadedClip=this._clips[index];if(!notLoadedClip&&this._$._currentTime>=this._clips[index].property(JVRE.BeginTime))
notLoadedClip=this._clips[index];}
if(state==JVRE.Media.LoadState.Loading){loading=true;break;}}
if(!loading){if(notLoadedClip)
notLoadedClip.load(this._$._context);else if(firstNotLoadedClip)
firstNotLoadedClip.load(this._$._context);}}
var allLoaded=false;if(this._$._currentClip!==currentClip){if(JVRE.Track.log)
debug.debug("[JVRE.Track] Clip change, currentTime:"+this._$._currentTime);if(this._$._currentClip!==null&&this._$._currentClip==previousClip){if(this._isLoaded(this._$._previousClip)){this._clips[this._$._previousClip].pause();}
this._$._previousClip=previousClip;this._$._currentClip=null;}
if(this._isLoaded(this._$._currentClip)){this._clips[this._$._currentClip].pause();}
this._$._currentClip=currentClip;if(currentClip!==null){var clip=this._clips[this._$._currentClip];if(clip.loadStare()==JVRE.Media.LoadState.Loaded){allLoaded=true;clip.currentTime(this._$._currentTime-clip.property(JVRE.BeginTime));}
else if(clip.loadStare()==JVRE.Media.LoadState.None)
clip.load(this._$._context);else{this._$._ready=false;this._$._loadStare=JVRE.Media.LoadState.Loading;this.fireEvent("sourceLoading");}}}
if(this._$._previousClip!==previousClip){if(JVRE.Track.log)
debug.debug("[JVRE.Track] Clip change, currentTime:"+this._$._currentTime);if(this._isLoaded(this._$._previousClip)){this._clips[this._$._previousClip].pause();this._$._previousClip=null;}
this._$._previousClip=previousClip;if(previousClip!==null){var clip=this._clips[this._$._previousClip];if(clip.loadStare()==JVRE.Media.LoadState.Loaded){allLoaded=true&&allLoaded;clip.currentTime(this._$._currentTime-clip.property(JVRE.BeginTime));}
else if(clip.loadStare()==JVRE.Media.LoadState.None)
clip.load(this._$._context);else{this._$._ready=false;this._$._loadStare=JVRE.Media.LoadState.Loading;this.fireEvent("sourceLoading");}}}
if(this._clips.length==0)
allLoaded=true;if(allLoaded==true&&this._$._loadStare==JVRE.Media.LoadState.Loading){this._$._ready=true;this._$._loadStare=JVRE.Media.LoadState.Loaded;this.fireEvent("sourceLoaded");this.fireEvent("sourceReady");}
else if(allLoaded==true&&this._$._loadStare==JVRE.Media.LoadState.Loaded&&this._$._ready==false&&this._allReady()){this._$._ready=true;this.fireEvent("sourceReady");}
if(previousClip===null&&currentClip===null){if(this._$._currentTime>this.duration()){this._$._ready=true;this.fireEvent("sourceReady");this.fireEvent("sourceEnd");}}},run:function(currentTime){this._$._currentTime=currentTime;this._schedule();var context=this._$._context;var posSync=0,nagSync=0;if(this._isLoaded(this._$._previousClip)){var clip=this._clips[this._$._previousClip];if(this._$._currentTime-clip.property(JVRE.BeginTime)<clip.duration()){var sync=clip.run(this._$._currentTime-clip.property(JVRE.BeginTime));if(sync>0&&sync>posSync)
posSync=sync;if(sync<0&&sync<nagSync)
nagSync=sync;}}
if(this._isLoaded(this._$._currentClip)){var clip=this._clips[this._$._currentClip];if(this._$._currentTime-clip.property(JVRE.BeginTime)<clip.duration()){var sync=clip.run(this._$._currentTime-clip.property(JVRE.BeginTime));if(sync>0&&sync>posSync)
posSync=sync;if(sync<0&&sync<nagSync)
nagSync=sync;}}
if(posSync-nagSync>context.unsync_threshold){if(JVRE.Track.log)
debug.warn("[JVRE.Track] Source not sync:"+(posSync-nagSync)+" threshold:"+context.unsync_threshold);this.fireEvent("sourceNotSync");}
return posSync-nagSync;},reset:function(){this.parent();if(JVRE.Track.log)
debug.debug("[JVRE.Track] reset");this._$._currentClip=null;this._$._previousClip=null;Array.each(this._clips,function(clip){clip.reset();});this._update();},load:function(context){this.parent(context);if(JVRE.Track.log)
debug.debug("[JVRE.Track] load");for(var index=0;index<this._clips.length;++index){var begin=this._clips[index].property(JVRE.BeginTime);var end=begin+this._clips[index].duration();if(begin<=this._$._currentTime&&this._$._currentTime<end){this._$._previousClip=this._$._currentClip;this._$._currentClip=index;}}
var load=false;var that=this;Array.each(this._clips,function(clip){if(clip.delayLoad()==false){load=true;clip.load(context);}
else{var begin=clip.property(JVRE.BeginTime);if(clip.loadStare()==JVRE.Media.LoadState.None&&begin<=that._$._currentTime&&that._$._currentTime<begin+clip.duration()){load=true;clip.load(context);}}});if(load==false){this._$._ready=true;this._$._loadStare=JVRE.Media.LoadState.Loaded;this.fireEvent("sourceLoaded");this.fireEvent("sourceReady");}},play:function(){if(JVRE.Track.log)
debug.debug("[JVRE.Track] play, currentTime:"+this._$._currentTime);if(this._isLoaded(this._$._previousClip))
this._clips[this._$._previousClip].play();if(this._isLoaded(this._$._currentClip))
this._clips[this._$._currentClip].play();},pause:function(){if(JVRE.Track.log)
debug.debug("[JVRE.Track] pause, currentTime:"+this._$._currentTime);if(this._isLoaded(this._$._previousClip))
this._clips[this._$._previousClip].pause();if(this._isLoaded(this._$._currentClip))
this._clips[this._$._currentClip].pause();},currentTime:function(time){if(time===undefined){return this._$._currentTime;}
else{if(JVRE.Track.log)
debug.debug("[JVRE.Track] seek, currentTime:"+time);this._$._currentTime=time;if(this._isLoaded(this._$._previousClip)){this._clips[this._$._previousClip].pause();this._$._previousClip=null;}
if(this._isLoaded(this._$._currentClip)){this._clips[this._$._currentClip].pause();this._$._currentClip=null;}
this._schedule();}},buffered:function(time){var previousClip=null;var currentClip=null;for(var index=0;index<this._clips.length;++index){var begin=this._clips[index].property(JVRE.BeginTime);var end=begin+this._clips[index].duration();if(begin<=time&&time<end){previousClip=currentClip;currentClip=index;}}
var previousResult=true;var currentResult=true;if(previousClip!==null){var clip=this._clips[previousClip];var previousResult=clip.buffered(time-clip.property(JVRE.BeginTime));}
if(currentClip!==null){var clip=this._clips[currentClip];var currentResult=clip.buffered(time-clip.property(JVRE.BeginTime));}
return previousResult&&currentResult;},render:function(context){context.target.save();var orgVolume=context.global_volume;context.global_volume=this._mixVolume(context);if(this._isLoaded(this._$._previousClip))
this._clips[this._$._previousClip].render(context);if(this._isLoaded(this._$._currentClip))
this._clips[this._$._currentClip].render(context);context.global_volume=orgVolume;context.target.restore();}};}());JVRE.Track.log=false;JVRE.Track.VTrack=new Class(function(){return{Extends:JVRE.Track,Implements:[JVRE.VTransformation,JVRE.VEffection],_$pt:"Track.VTrack",_sourceClass:JVRE.Clip.VClip,initialize:function(){this.parent();this._initializeTransformation();this._initializeEffection();this.bgColorR=new JVRE.IP(255);this.bgColorG=new JVRE.IP(255);this.bgColorB=new JVRE.IP(255);this.bgColorA=new JVRE.IP(0);this._$=this._$||{};this._$._buffer=this._$._buffer||null;},load:function(context){this.parent(context);if(this._$._buffer===null){this._$._buffer=document.createElement('canvas');this._$._buffer.width=context.width;this._$._buffer.height=context.height;}
this._loadEffection(context);},render:function(context){var oldTarget=null;if(context.track_transformation){oldTarget=context.target;context.target=this._$._buffer.getContext("2d");context.target.clearRect(0,0,context.width,context.height);}
context.target.save();context.target.fillStyle="rgba("+
this.bgColorR.value(this._$._currentTime)+","+
this.bgColorG.value(this._$._currentTime)+","+
this.bgColorB.value(this._$._currentTime)+","+
this.bgColorA.value(this._$._currentTime)+")";context.target.fillRect(0,0,context.width,context.height);context.target.restore();context.target.save();this.parent(context);context.target.restore();if(context.track_effection)
this._renderEffect(context);if(context.track_transformation){context.target=oldTarget;context.target.save();this._setTransformatContext(context.target);context.target.drawImage(this._$._buffer,0,0);context.target.restore();}},hitTest:function(x,y){var compute=this._tranConvert(this._$._currentTime);var result={object:this,tran:compute,child:[]};var xy=compute.invert(x,y);var convert=function(obj){if(obj.box){obj.box.a=compute.convert(obj.box.a.x,obj.box.a.y);obj.box.b=compute.convert(obj.box.b.x,obj.box.b.y);obj.box.c=compute.convert(obj.box.c.x,obj.box.c.y);obj.box.d=compute.convert(obj.box.d.x,obj.box.d.y);}
if(obj.child){for(var index=0;index<obj.child.length;++index)
convert(obj.child[index]);}
return obj;}
if(this._$._currentClip!=null){var obj=this._clips[this._$._currentClip].hitTest(xy.x,xy.y);if(obj!=null)
result.child.push(convert(obj));}
if(this._$._previousClip!=null){var obj=this._clips[this._$._previousClip].hitTest(xy.x,xy.y);if(obj!=null)
result.child.push(convert(obj));}
if(result.child.length!=0)
return result;return null;}};}());JVRE.Track.ATrack=new Class(function(){return{Extends:JVRE.Track,_$pt:"Track.ATrack",_sourceClass:JVRE.Clip.AClip,initialize:function(){this.parent();}};}());JVRE.Timeline=new Class(function(){return{Extends:JVRE.Media,_$pt:"Timeline",initialize:function(){this.parent();this._$=this._$||{};this.bgColorR=new JVRE.IP(0);this.bgColorG=new JVRE.IP(0);this.bgColorB=new JVRE.IP(0);this.bgColorA=new JVRE.IP(1);this._width=480;this._height=360;this._duration=null;this._tracks=[];},_allReady:function(){var all=true;Array.each(this._tracks,function(track){all=all&&(track.isPresent()==false||track.isReady());});return all;},_allLoaded:function(){var all=true;Array.each(this._tracks,function(track){all=all&&(track.isPresent()==false||track.loadStare()==JVRE.Media.LoadState.Loaded);});return all;},_bindEvent:function(track){var that=this;track.addEvent("sourceLoading",this._$.loadingCallback=function(){if(JVRE.Timeline.log)
debug.warn("[JVRE.Timeline] loading");that._$._ready=false;that._$._loadStare=JVRE.Media.LoadState.Loading;that.fireEvent("sourceLoading");});track.addEvent("sourceLoaded",this._$.loadedCallback=function(){if(that._allLoaded()){if(JVRE.Timeline.log)
debug.warn("[JVRE.Timeline] loaded");that._$._ready=true;that._$._loadStare=JVRE.Media.LoadState.Loaded;that.fireEvent("sourceLoaded");that._schedule();}});track.addEvent("sourceReady",this._$.readyCallback=function(){if(that._allLoaded()&&that._allReady()){if(JVRE.Timeline.log)
debug.warn("[JVRE.Timeline] ready");that._$._ready=true;that.fireEvent("sourceReady");}});track.addEvent("sourceNotReady",this._$.notReadyCallback=function(){if(JVRE.Timeline.log)
debug.warn("[JVRE.Timeline] notReady");that._$._ready=false;that.fireEvent("sourceNotReady");});track.addEvent("sourceNotSync",this._$.notSyncCallback=function(){that.fireEvent("sourceNotSync");});track.addEvent("sourceStalled",this._$.stalledCallback=function(){that.fireEvent("sourceStalled");});track.addEvent("sourceError",this._$.errorCallback=function(){that._$._ready=false;that.fireEvent("sourceError");});},_unbindEvent:function(track){if(track){track.removeEvent("sourceLoading",this._$.loadingCallback);track.removeEvent("sourceLoaded",this._$.loadedCallback);track.removeEvent("sourceReady",this._$.readyCallback);track.removeEvent("sourceNotReady",this._$.notReadyCallback);track.removeEvent("sourceNotSync",this._$.notSyncCallback);track.removeEvent("sourceStalled",this._$.stalledCallback);track.removeEvent("sourceError",this._$.errorCallback);}},dump:function(){var timeline=$("<div class='timeline'/>").css({border:0,color:"#000000","background-color":"#686868","font-size":9,height:this._tracks.length*85+5,width:this.duration()*20});timeline[0].associate=this;Array.each(this._tracks,function(track,index){timeline.append(track.dump().css("top",5));timeline.append($("<div/>").css({border:0,position:"relative",height:5}));});return timeline;},_unserialize:function(data){this.parent(data);var that=this;Array.each(this._tracks,function(track){that._bindEvent(track);});},_update:function(){if(this._$._context!=null)
this._schedule();},width:function(width){if(width===undefined)
return this._width;else
this._width=width;},height:function(height){if(height===undefined)
return this._height;else
this._height=height;},duration:function(){if(this._duration!==null)
return this._duration;var duration=0;Array.each(this._tracks,function(track){var newDuration=track.duration();if(duration<newDuration)
duration=newDuration;});return duration;},count:function(){return this._tracks.length;},tracks:function(index){return this._tracks[index];},indexOf:function(track){return this._tracks.indexOf(track);},push:function(){var that=this;Array.each(arguments,function(track){if(instanceOf(track,JVRE.Track)&&(track.context()===null||track.context()===that.context())){that._tracks.push(track);that._bindEvent(track);if(track.context()===null&&that.context()!==null)
track.load(that.context());}
else throw new JVRE.Exception("track invalid argument",JVRE.Error.E_INVALIDARG);});this._update();},del:function(index,count){if(index>=this._tracks.length||index<0)
throw new JVRE.Exception("index invalid argument",JVRE.Error.E_INVALIDARG);count=count||1;if(index+count>this._tracks.length||count<1)
throw new JVRE.Exception("count invalid argument",JVRE.Error.E_INVALIDARG);for(var i=index;i<index+count;++i){this._unbindEvent(this._tracks[i]);if(this._tracks[i].isReady())
this._tracks[i].pause();}
this._tracks.splice(index,count);this._update();},swap:function(indexA,indexB){if(indexA>=this._tracks.length||indexA<0)
throw new JVRE.Exception("indexA invalid argument",JVRE.Error.E_INVALIDARG);if(indexB>=this._tracks.length||indexB<0)
throw new JVRE.Exception("indexB invalid argument",JVRE.Error.E_INVALIDARG);var tmp=this._tracks[indexA];this._tracks[indexA]=this._tracks[indexB];this._tracks[indexB]=tmp;this._update();},reset:function(){this.parent();if(JVRE.Track.log)
debug.debug("[JVRE.Timeline] reset");Array.each(this._tracks,function(track){track.reset();});this._update();},load:function(context){this.parent(context);if(JVRE.Timeline.log)
debug.debug("[JVRE.Timeline] load");Array.each(this._tracks,function(track){track.load(context);});},networkIdle:function(){if(this._tracks.length!=0){for(var index=0;index<this._tracks.length;++index){if(this._tracks[index].networkIdle()==false)
return false;}
return true;}
else return true;},_schedule:function(){if(this._allLoaded()&&this._$._loadStare==JVRE.Media.LoadState.Loading){this._$._ready=true;this._$._loadStare=JVRE.Media.LoadState.Loaded;this.fireEvent("sourceLoaded");this.fireEvent("sourceReady");}
if(this._$._currentTime>this.duration()){this.fireEvent("sourceReady");this.fireEvent("sourceEnd");}},run:function(currentTime){this._$._currentTime=currentTime;this._schedule();var context=this._$._context;var posSync=0,nagSync=0;var that=this;Array.each(this._tracks,function(track){var sync=track.run(that._$._currentTime);if(sync>0&&sync>posSync)
posSync=sync;if(sync<0&&sync<nagSync)
nagSync=sync;});if(posSync-nagSync>context.unsync_threshold){if(JVRE.Timeline.log)
debug.warn("[JVRE.Timeline] Source not sync:"+(posSync-nagSync)+" threshold:"+context.unsync_threshold);this.fireEvent("sourceNotSync");}
return posSync-nagSync;},play:function(){if(JVRE.Timeline.log)
debug.debug("[JVRE.Timeline] play, currentTime:"+this._$._currentTime);Array.each(this._tracks,function(track){track.play();});},pause:function(){if(JVRE.Timeline.log)
debug.debug("[JVRE.Timeline] pause, currentTime:"+this._$._currentTime);Array.each(this._tracks,function(track){track.pause();});},currentTime:function(time){if(time===undefined){return this._$._currentTime;}
else{if(JVRE.Timeline.log)
debug.debug("[JVRE.Timeline] seek, currentTime:"+time);this._$._currentTime=time;Array.each(this._tracks,function(track){track.currentTime(time);});this._schedule();}},buffered:function(time){var result=true;var that=this;Array.each(this._tracks,function(track){result=result&&track.buffered(time);});return result;},render:function(context){context.target.save();context.target.fillStyle="rgba("+
this.bgColorR.value(this._$._currentTime)+","+
this.bgColorG.value(this._$._currentTime)+","+
this.bgColorB.value(this._$._currentTime)+","+
this.bgColorA.value(this._$._currentTime)+")";context.target.clearRect(0,0,this._width,this._height);context.target.fillRect(0,0,this._width,this._height);context.target.restore();context.target.save();Array.each(this._tracks,function(track){track.render(context);});context.target.restore();},hitTest:function(x,y){var result={object:this,child:[]};for(var index=this._tracks.length-1;index>=0;--index){var track=this._tracks[index];if(track.hitTest!==undefined){var obj=track.hitTest(x,y);if(obj!=null)
result.child.push(obj);}}
if(result.child.length!=0)
return result;return null;}};}());JVRE.Timeline.log=false;JVRE.Render=new Class(function(){return{Extends:JVRE.Base,Implements:Events,initialize:function(){this.parent();this._playing=false;this._state=JVRE.Render.State.None;this._refTime=null;this._currentTime=0;this._replay=true;this._replayCount=0;this._delayTime=0;this._bufferingCount=0;this._bufferingTime=null;this._unsyncCount=0;this._stalledCount=0;this._totalTime=0;this._resumeTime=null;this._source=null;this._buffer=null;this._context={diagnostic:JVRE.Debug,log:JVRE.Debug,clip_effection:false,clip_transformation:true,track_effection:false,track_transformation:false,width:480,height:360,target:null,source_resolver:null,global_volume:1,unsync_threshold:0.75,unsync_resume_time:5,buffering_threshold:1,buffering_resume_time:1,preload_time:30,render_type:JVRE.Effect.VEffect.Type.WebGL};JVRE.Render.log=this._context.log;JVRE.Timeline.log=this._context.log;JVRE.Effect.log=this._context.log;JVRE.Track.log=this._context.log;JVRE.Clip.log=this._context.log;JVRE.Source.log=this._context.log;},diagnostic:function(enable){if(enable===undefined)
return this._context.diagnostic;else
this._context.diagnostic=enable;},log:function(enable){if(enable===undefined)
return this._context.log;else
this._context.log=enable;JVRE.log=enable;JVRE.Render.log=enable;JVRE.Timeline.log=enable;JVRE.Effect.log=enable;JVRE.Track.log=enable;JVRE.Clip.log=enable;JVRE.Source.log=enable;},sourceResolver:function(resolver){if(resolver==undefined)
return this._context.source_resolver;else
this._context.source_resolver=resolver;},_unbindEvent:function(){this._source.removeEvent("sourceLoading",this._loadingCallback);this._source.removeEvent("sourceLoaded",this._loadedCallback);this._source.removeEvent("sourceReady",this._readyCallback);this._source.removeEvent("sourceNotReady",this._notReadyCallback);this._source.removeEvent("sourceNotSync",this._notSyncCallback);this._source.removeEvent("sourceEnd",this._endCallback)
this._source.removeEvent("sourceStalled",this._stalledCallback);this._source.removeEvent("sourceError",this._errorCallback);},_bindEvent:function(){var that=this;this._source.addEvent("sourceLoading",this._loadingCallback=function(){if(JVRE.Render.log)
debug.warn("[JVRE.Render] loading, currentTime:"+that._currentTime);that._state=JVRE.Render.State.Loading;that._bufferingTime=null;that._source.pause();that.fireEvent("sourceLoading");});this._source.addEvent("sourceLoaded",this._loadedCallback=function(){if(JVRE.Render.log)
debug.warn("[JVRE.Render] loaded, currentTime:"+that._currentTime);that._state=JVRE.Render.State.Waiting;that._bufferingTime=null;that._source.pause();that.fireEvent("sourceLoaded");});this._source.addEvent("sourceReady",this._readyCallback=function(){if(JVRE.Render.log)
debug.warn("[JVRE.Render] ready, currentTime:"+that._currentTime);if(that._bufferingTime!=null&&that._refTime.getTime()/1000-that._bufferingTime>that._context.buffering_threshold){that._resumeTime=that._context.buffering_resume_time;}
that._bufferingTime=null;if(that._state==JVRE.Render.State.Waiting&&that._resumeTime===null){that._state=JVRE.Render.State.Ready;if(that._playing)
that._source.play();that.fireEvent("sourceReady");}});this._source.addEvent("sourceNotReady",this._notReadyCallback=function(){if(JVRE.Render.log)
debug.warn("[JVRE.Render] notReady, currentTime:"+that._currentTime);++that._bufferingCount;var newRefTime=new Date();that._bufferingTime=newRefTime.getTime()/1000;if(that._state==JVRE.Render.State.Ready){that._state=JVRE.Render.State.Waiting;that._source.pause();that.fireEvent("sourceNotReady");}});this._source.addEvent("sourceNotSync",this._notSyncCallback=function(){if(JVRE.Render.log)
debug.warn("[JVRE.Render] notSync, currentTime:"+that._currentTime);++that._unsyncCount;that._resumeTime=that._context.unsync_resume_time;if(that._state==JVRE.Render.State.Ready){that._state=JVRE.Render.State.Waiting;that._source.pause();that._source.currentTime(that._currentTime);that.fireEvent("sourceNotSync");}});this._source.addEvent("sourceEnd",this._endCallback=function(){if(JVRE.Render.log)
debug.warn("[JVRE.Render] end, currentTime:"+that._currentTime);that._state=JVRE.Render.State.Ready;that._bufferingTime=null;that._currentTime=0;that._playing=false;that._source.pause();that.fireEvent("sourceEnd");if(that._replay){++that._replayCount;that.play();}});this._source.addEvent("sourceStalled",this._stalledCallback=function(){++that._stalledCount
that.fireEvent("sourceStalled");});this._source.addEvent("sourceError",this._errorCallback=function(){if(JVRE.Render.log)
debug.error("[JVRE.Render] error");that._state=JVRE.Render.State.Error;that._playing=false;that._currentTime=0;that._source.pause();that.fireEvent("sourceError");});},source:function(source){if(source==undefined)
return this._source;else{if(this._state!=JVRE.Render.State.None)throw new JVRE.Exception();if(this._source){this._unbindEvent();this._source=null;}
this._source=source;this._bindEvent();this._currentTime=0;this._context.width=source.width&&source.width()!==null?source.width():this._context.width;this._context.height=source.height&&source.height()!==null?source.height():this._context.height;this._buffer=document.createElement('canvas');this._buffer.width=this._context.width;this._buffer.height=this._context.height;this._context.target=this._buffer.getContext('2d');}},volume:function(volume){if(volume==undefined)
return this._context.global_volume;else{if(volume<0||1<volume)
throw new JVRE.Exception("volume invalid argument",JVRE.Error.E_INVALIDARG);this._context.global_volume=volume;}},state:function(){return this._state;},isPlay:function(){return this._playing;},replay:function(replay){if(replay==undefined)
return this._replay;else
this._replay=replay;},run:function(){var newRefTime=new Date();var timeDelta=this._refTime?(newRefTime.getTime()-this._refTime.getTime())/1000:0;this._refTime=newRefTime;var sync=0;if(this._state==JVRE.Render.State.Ready&&this._playing)
this._currentTime+=timeDelta;if(this._state!=JVRE.Render.State.None&&this._state!=JVRE.Render.State.Ready)
this._delayTime+=timeDelta;this._totalTime+=timeDelta;if(this._resumeTime!==null){this._resumeTime-=timeDelta;if(this._resumeTime<0){this._resumeTime=null;this._state=JVRE.Render.State.Ready;if(this._playing)
this._source.play();this.fireEvent("sourceReady");}}
if(this._state==JVRE.Render.State.Ready)
sync=this._source.run(this._currentTime);if(this._context.target!==null)
this._render(timeDelta,sync);this.fireEvent("progress",[this._currentTime]);},_render:function(timeDelta,sync){this._context.target.save();if(this._source){if(this._state==JVRE.Render.State.Ready){this._context.target.clearRect(0,0,this._context.width,this._context.height);this._source.render(this._context);}
if(this._context.diagnostic)
this._context.target.fillRect(0,0,150,150);}
if(this._context.diagnostic){this._context.target.beginPath();for(var x=0;x<=this._context.width;x+=100){this._context.target.moveTo(x,0);this._context.target.lineTo(x,this._context.height);}
for(var y=0;y<=this._context.height;y+=100){this._context.target.moveTo(0,y);this._context.target.lineTo(this._context.width,y);}
this._context.target.strokeStyle="#333333";this._context.target.stroke();this._context.target.closePath();this._context.target.globalAlpha=1;this._context.target.fillStyle="#FF0000";this._context.target.fillText("FPS: "+(1/timeDelta).toString().slice(0,5),10,15);var state=JVRE.Render.State.None;switch(this._state){case JVRE.Render.State.None:state="None";break;case JVRE.Render.State.Loading:state="Loading";break;case JVRE.Render.State.Waiting:state="Waiting";break;case JVRE.Render.State.Ready:state="Ready";break;case JVRE.Render.State.End:state="End";break;case JVRE.Render.State.Error:state="Error";break;};this._context.target.fillText("State: "+state+" Stalled: "+this._stalledCount,10,30);this._context.target.fillText("Time: "+this._currentTime.toString().slice(0,5)+"/"+this._source.duration()+" ["+this._replayCount+"]",10,45);this._context.target.fillText("Sync: "+sync.toString().slice(0,5)+" ["+this._unsyncCount+"]",10,60);var delayP=0;if(this._source.loadStare()==JVRE.Media.LoadState.Loaded&&this._totalTime!=0)
delayP=this._delayTime*100/this._totalTime;this._context.target.fillText("Delay: "+this._delayTime.toString().slice(0,5)+"/"+delayP.toString().slice(0,4)+"%",10,75);if(this._bufferingTime!==null)
this._context.target.fillText("Buffering: "+(this._refTime.getTime()/1000-this._bufferingTime).toString().slice(0,5)+" ["+this._bufferingCount+"]",10,90);else
this._context.target.fillText("Buffering: OK ["+this._bufferingCount+"]",10,90);if(this._resumeTime!==null)
this._context.target.fillText("Resume: "+this._resumeTime.toString().slice(0,5),10,105);else
this._context.target.fillText("Resume: OK",10,105);}
this._context.target.restore();},reset:function(){if(this._state!=JVRE.Render.State.None){this._source.pause();this._source.reset();}
this._playing=false;this._state=JVRE.Render.State.None;this._refTime=null;this._currentTime=0;},load:function(){if(!this._source)throw new JVRE.Exception();if(this._state!=JVRE.Render.State.None)throw new JVRE.Exception();this._state=JVRE.Render.State.Loading;if(JVRE.Render.log)
debug.debug("[JVRE.Render] load");this._source.load(this._context);},play:function(){if(!this._source)throw new JVRE.Exception();if(this._state==JVRE.Render.State.None)throw new JVRE.Exception();if(JVRE.Render.log)
debug.debug("[JVRE.Render] play, currentTime:"+this._currentTime);if(!this._playing){this._playing=true;if(this._state==JVRE.Render.State.Ready)
this._source.play();}},pause:function(){if(!this._source)throw new JVRE.Exception();if(this._state==JVRE.Render.State.None)throw new JVRE.Exception();if(JVRE.Render.log)
debug.debug("[JVRE.Render] pause, currentTime:"+this._currentTime);if(this._playing){this._playing=false;if(this._state==JVRE.Render.State.Ready)
this._source.pause();}},currentTime:function(time){if(!this._source)throw new JVRE.Exception();if(this._state==JVRE.Render.State.None)throw new JVRE.Exception();if(time==undefined){return this._currentTime;}
else{if(time<0||this.duration()<time)
throw new JVRE.Exception("time invalid argument",JVRE.Error.E_INVALIDARG);if(JVRE.Render.log)
debug.debug("[JVRE.Render] seek, currentTime:"+time);this._currentTime=time;if(this._state==JVRE.Render.State.Ready){this._source.pause();this._source.currentTime(time);}}},buffered:function(time){if(!this._source)throw new JVRE.Exception();return this._source.buffered(time);},duration:function(){if(!this._source)throw new JVRE.Exception();if(this._state==JVRE.Render.State.None)throw new JVRE.Exception();return this._source.duration();},result:function(){return this._buffer;},hitTest:function(x,y){if(!this._source)throw new JVRE.Exception();if(this._source.hitTest!==undefined)
return this._source.hitTest(x,y);else return[];}};}());JVRE.Render.log=false;JVRE.Render.State={None:0,Loading:1,Waiting:2,Ready:3,Error:4};JVRE.ModuleName="JavaScript Video Render Engine v1.0.0.x";JVRE.Copyright="Copyright 2011, Corel Corporation";JVRE.MajorVer=1;JVRE.MinorVer=0;JVRE.Build=0;JVRE.Fix=65;